/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.transition.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class TemporaryStateScope<T> {
    private final List<TemporalHolder<T>> holders;

    public TemporaryStateScope(Collection<TemporalHolder<T>> holders) {
        this.holders = new ArrayList<TemporalHolder<T>>(holders);
    }

    public void apply(T obj, Consumer<T> consumer) {
        for (TemporalHolder<T> holder : this.holders) {
            holder.prepareState(obj);
        }
        consumer.accept(obj);
        for (int i = this.holders.size() - 1; i >= 0; --i) {
            this.holders.get(i).revertSate(obj);
        }
    }

    public static interface TemporalHolder<T> {
        public void prepareState(T var1);

        public void revertSate(T var1);
    }
}

